<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') { 
    $categoryId = $_POST['categoryid'] ?? null;
    $productId = $_POST['productid'] ?? null;
    $productName = $_POST['productname'] ?? null;
    $productTotal = $_POST['producttotal'] ?? 0;
    $taps = $_POST['taps'] ?? 0;

    // Ensure session is initialized
    if (!isset($_SESSION)) {
        echo json_encode(['status' => 'error', 'message' => 'Session not initialized']);
        exit;
    }

    if ($categoryId && $productId) {
        // Use a non-numeric session key by prefixing with "category_"
        $categoryKey = "category_" . (string)$categoryId;

        // Initialize session for category if not already
        if (!isset($_SESSION[$categoryKey])) {
            $_SESSION[$categoryKey] = [];
            echo json_encode(['status' => 'debug', 'message' => 'Session for category created']);
        }

        // Check if product exists and update
        if (isset($_SESSION[$categoryKey][$productId])) {
            $_SESSION[$categoryKey][$productId]['productTotal'] = $productTotal;
            $_SESSION[$categoryKey][$productId]['taps'] = $taps;
        } else {
            // Add new product to session
            $_SESSION[$categoryKey][$productId] = [
                'productName' => $productName,
                'productTotal' => $productTotal,
                'taps' => $taps,
            ];
        }

        echo json_encode([
            'status' => 'success', 
            'categoryId' => $categoryKey,
            'data' => $_SESSION[$categoryKey]
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Category ID or Product ID not provided']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
}
